(define/contract (minimum-operations-to-k-periodic word k)
  (-> string? exact-integer? exact-integer?)
  (let* ((n (string-length word))
         (freq (make-hash))
         (max-freq 0))
    (when (<= k n)
      (for ((i (in-range 0 k)))
        (let ((current-freq (make-hash)))
          (for ((j (in-range i n k)))
            (let ((c (string-ref word j)))
              (hash-update! current-freq c add1 0)))
          (for ([(key val) (in-hash current-freq)])
            (hash-update! freq key (lambda (v) (+ v val)) 0))
          (set! max-freq (max max-freq (apply max (hash-values current-freq))))))
    (- (if (zero? max-freq) 0 (quotient n k)) max-freq)))