(define/contract (minimum-substrings-equal-frequency s)
  (-> string? exact-integer?)
  (define n (string-length s))
  (define dp (make-vector (add1 n) +inf.0))
  (vector-set! dp 0 0)
  (for ([i (in-range 1 (add1 n))])
    (define freq (make-hash))
    (for ([j (in-range i 0 -1)])
      (define c (string-ref s (sub1 j)))
      (hash-update! freq c add1 1)
      (define vals (hash-values freq))
      (define first-val (first vals))
      (if (andmap (lambda (v) (= v first-val)) vals)
          (vector-set! dp i (min (vector-ref dp i)
                                 (add1 (vector-ref dp (sub1 j)))))))
  (vector-ref dp n))