(define/contract (block-placement-queries n queries)
  (-> exact-integer? (listof (listof exact-integer?)) (listof exact-integer?))
  (define blocks (make-hash))
  (hash-set! blocks 1 n)
  (define res '())
  (for ([q queries])
    (match q
      [(list 1 x)
       (for ([(k v) (hash-copy blocks)])
         (when (<= x (+ k v -1))
           (hash-remove! blocks k)
           (when (< k x)
             (hash-set! blocks k (- x k)))
           (when (< x (+ k v -1))
             (hash-set! blocks (add1 x) (- (+ k v -1) x))
           (break)))]
      [(list 2 x)
       (define found #f)
       (for ([(k v) blocks])
         (when (<= k x (+ k v -1))
           (set! res (cons v res))
           (set! found #t)
           (break)))
       (unless found (set! res (cons 0 res)))]))
  (reverse res))