(define/contract (count-complete-day-pairs hours)
  (-> (listof exact-integer?) exact-integer?)
  (define mod-map (make-hash))
  (define count 0)
  (for ([h (in-list hours)])
    (define mod (modulo h 24))
    (define complement (modulo (- 24 mod) 24))
    (set! count (+ count (hash-ref mod-map complement 0)))
    (hash-update! mod-map mod add1 0))
  count)