(define/contract (count-submatrices grid x y)
  (-> (listof (listof exact-integer?)) exact-integer? exact-integer? exact-integer?)
  (define rows (length grid))
  (define cols (if (zero? rows) 0 (length (car grid))))
  (define prefix (make-vector (+ rows 1) (make-vector (+ cols 1) (make-hash))))

  (for ([i (in-range 1 (+ rows 1))])
    (for ([j (in-range 1 (+ cols 1))])
      (define current (vector-ref (vector-ref grid (- i 1)) (- j 1)))
      (define up (vector-ref (vector-ref prefix (- i 1)) j))
      (define left (vector-ref (vector-ref prefix i) (- j 1)))
      (define up-left (vector-ref (vector-ref prefix (- i 1)) (- j 1)))

      (define new-hash (make-hash))
      (hash-for-each up (lambda (k v) (hash-set! new-hash k v)))
      (hash-for-each left (lambda (k v) (hash-set! new-hash k (+ v (hash-ref left k 0)))))
      (hash-for-each up-left (lambda (k v) (hash-set! new-hash k (- (hash-ref new-hash k 0) v))))
      (hash-set! new-hash current (+ (hash-ref new-hash current 0) 1))

      (vector-set! (vector-ref prefix i) j new-hash)))

  (define count 0)
  (for ([i1 (in-range 1 (+ rows 1))])
    (for ([j1 (in-range 1 (+ cols 1))])
      (for ([i2 (in-range i1 (+ rows 1))])
        (for ([j2 (in-range j1 (+ cols 1))])
          (define submatrix (vector-ref (vector-ref prefix i2) j2))
          (define up (vector-ref (vector-ref prefix (- i1 1)) j2))
          (define left (vector-ref (vector-ref prefix i2) (- j1 1)))
          (define up-left (vector-ref (vector-ref prefix (- i1 1)) (- j1 1)))

          (define cnt-x 0)
          (define cnt-y 0)
          (hash-for-each submatrix (lambda (k v)
            (when (equal? k x) (set! cnt-x (+ cnt-x v)))
            (when (equal? k y) (set! cnt-y (+ cnt-y v)))))
          (hash-for-each up (lambda (k v)
            (when (equal? k x) (set! cnt-x (- cnt-x v)))
            (when (equal? k y) (set! cnt-y (- cnt-y v)))))
          (hash-for-each left (lambda (k v)
            (when (equal? k x) (set! cnt-x (- cnt-x v)))
            (when (equal? k y) (set! cnt-y (- cnt-y v)))))
          (hash-for-each up-left (lambda (k v)
            (when (equal? k x) (set! cnt-x (+ cnt-x v)))
            (when (equal? k y) (set! cnt-y (+ cnt-y v)))))

          (when (equal? cnt-x cnt-y)
            (set! count (+ count 1)))))))
  count)