#lang racket

(require data/heap)

(define/contract (shortest-distance n roads queries)
  (-> exact-integer? (listof (listof exact-integer?)) (listof (listof exact-integer?)) (listof exact-integer?))
  (define adj (make-vector n (make-hash)))
  (for ([road roads])
    (match-define (list u v w) road)
    (hash-set! (vector-ref adj u) v w)
    (hash-set! (vector-ref adj v) u w))

  (define (dijkstra start)
    (define dist (make-vector n +inf.0))
    (vector-set! dist start 0)
    (define heap (make-heap (lambda (a b) (< (car a) (car b)))))
    (heap-add! heap (cons 0 start))
    (let loop ()
      (when (not (heap-empty? heap))
        (match-define (cons d u) (heap-min heap))
        (heap-remove! heap)
        (when (= d (vector-ref dist u))
          (for ([(v w) (in-hash (vector-ref adj u))])
            (define new-dist (+ d w))
            (when (< new-dist (vector-ref dist v))
              (vector-set! dist v new-dist)
              (heap-add! heap (cons new-dist v))))))
        (loop)))
    dist)

  (define dists (make-vector n #f))
  (for ([i (in-range n)])
    (vector-set! dists i (dijkstra i)))

  (for/list ([query queries])
    (match-define (list x y w) query)
    (define min-dist (vector-ref (vector-ref dists x) y))
    (hash-set! (vector-ref adj x) y w)
    (hash-set! (vector-ref adj y) x w)
    (define new-dist (vector-ref (dijkstra x) y)
    (vector-set! dists x (dijkstra x))
    (vector-set! dists y (dijkstra y))
    new-dist))