#lang racket

(define/contract (find-snake matrix)
  (-> (listof (listof exact-integer?)) (listof (listof exact-integer?)))
  (define rows (length matrix))
  (if (zero? rows) '()
      (define cols (length (car matrix)))
      (define max-len 0)
      (define result '())
      (define dirs '((0 1) (1 0) (0 -1) (-1 0)))

      (define (dfs i j path)
        (define val (list-ref (list-ref matrix i) j))
        (define next-val (+ val 1))
        (define found #f)
        (for ([dir dirs])
          (define ni (+ i (car dir)))
          (define nj (+ j (cadr dir)))
          (when (and (>= ni 0) (< ni rows) (>= nj 0) (< nj cols)
                     (= (list-ref (list-ref matrix ni) nj) next-val))
            (set! found #t)
            (dfs ni nj (cons (list ni nj) path))))
        (when (not found)
          (define len (length path))
          (when (> len max-len)
            (set! max-len len)
            (set! result (reverse path)))))

      (for ([i (in-range rows)])
        (for ([j (in-range cols)])
          (dfs i j (list (list i j)))))
      (if (null? result) '() result)))