(define (count-substrings s k)
  (define n (string-length s))
  (define count 0)
  (for ([i n])
    (define freq (make-hash))
    (define distinct 0)
    (for ([j (in-range i n)])
      (define c (string-ref s j))
      (hash-update! freq c (lambda (v) (+ v 1)) (lambda () 0))
      (when (= (hash-ref freq c) 1)
        (set! distinct (+ distinct 1)))
      (when (>= distinct k)
        (set! count (+ count 1)))))
  count)