(define/contract (count-substrings s k)
  (-> string? exact-integer? exact-integer?)
  (define n (string-length s))
  (define count 0)
  (for* ([i (in-range n)]
         [j (in-range i (min n (+ i 26)))])
    (define freq (make-hash))
    (define distinct 0)
    (for ([l (in-range i (add1 j))])
      (define c (string-ref s l))
      (hash-update! freq c (lambda (v) (add1 v)) 0)
      (when (= (hash-ref freq c) 1)
        (set! distinct (add1 distinct)))
    (when (>= distinct k)
      (set! count (add1 count))))
  count)