(define/contract (minimum-valid-strings source target)
  (-> string? string? exact-integer?)
  (let* ((n (string-length source))
         (m (string-length target))
         (dp (make-vector (add1 m) +inf.0)))
    (vector-set! dp 0 0)
    (for ([i (in-range m)])
      (when (< (vector-ref dp i) +inf.0)
        (for ([j (in-range n)])
          (let ((k 0))
            (while (and (< (+ i k) m)
                    (< (+ j k) n)
                   (char=? (string-ref target (+ i k))
                           (string-ref source (+ j k)))
              (set! k (add1 k)))
            (when (> k 0)
              (let ((next (+ i k)))
                (when (<= next m)
                  (vector-set! dp next
                              (min (vector-ref dp next)
                                   (add1 (vector-ref dp i)))))))))))
    (let ((result (vector-ref dp m)))
      (if (= result +inf.0) -1 result))))