(define (count-substrings s t)
  (define n (string-length s))
  (define m (string-length t))
  (define target (make-hash))
  (for ([c t])
    (hash-update! target c add1 0))
  (define target-count (hash-count target))
  (define result 0)

  (define (valid? window)
    (define cnt 0)
    (for ([(k v) target])
      (when (>= (hash-ref window k 0) v)
        (set! cnt (add1 cnt))))
    (>= cnt target-count))

  (define window (make-hash))
  (define left 0)
  (for ([right (in-range n)])
    (define c (string-ref s right))
    (hash-update! window c add1 0)
    (while (valid? window)
      (set! result (+ result (- n right)))
      (define left-char (string-ref s left))
      (hash-update! window left-char sub1)
      (when (zero? (hash-ref window left-char))
        (hash-remove! window left-char)
      (set! left (add1 left))))
  result)