(define/contract (count-vowel-substrings s k)
  (-> string? exact-integer? exact-integer?)
  (define vowels (set #\a #\e #\i #\o #\u))
  (define n (string-length s))
  (define count 0)
  (for ([i (in-range n)])
    (define vowel-set (mutable-set))
    (define consonant-count 0)
    (for ([j (in-range i n)])
      (define c (string-ref s j))
      (if (set-member? vowels c)
          (set-add! vowel-set c)
          (set! consonant-count (add1 consonant-count)))
      (when (and (= (set-count vowel-set) 5) (= consonant-count k))
        (set! count (add1 count)))))
  count)