(define (find-itinerary tickets)
  (let* ((graph (make-hash))
         (result '()))
    (for-each (lambda (ticket)
                (let ((from (car ticket))
                  (let ((to (cadr ticket)))
                    (if (hash-has-key? graph from)
                        (hash-set! graph from (cons to (hash-ref graph from)))
                        (hash-set! graph from (list to)))))))
              tickets)
    (for-each (lambda (key)
                (hash-set! graph key (sort (hash-ref graph key) string<?)))
              (hash-keys graph))
    (let dfs ((node "JFK"))
      (let ((neighbors (hash-ref graph node '())))
        (while (not (null? neighbors))
          (let ((next (car neighbors)))
            (hash-set! graph node (cdr neighbors))
            (dfs next)))
        (set! result (cons node result))))
    (dfs "JFK")
    result))