(define/contract (count-substrings s k)
  (-> string? exact-integer? exact-integer?)
  (define n (string-length s))
  (define count 0)
  (for ([i n])
    (define freq (make-hash))
    (for ([j (in-range i n)])
      (define c (string-ref s j))
      (hash-update! freq c add1 (lambda () 0))
      (when (ormap (lambda (v) (>= v k)) (hash-values freq))
        (set! count (add1 count)))))
  count)