(define/contract (palindrome-pairs words)
  (-> (listof string?) (listof (listof exact-integer?)))
  (define (is-palindrome s)
    (equal? s (list->string (reverse (string->list s)))))

  (define word-to-index (make-hash))
  (for ([(word idx) (in-indexed words)])
    (hash-set! word-to-index word idx))

  (define result '())
  (for ([(word idx) (in-indexed words)])
    (define n (string-length word))
    (for ([i (in-range (+ n 1))])
      (define prefix (substring word 0 i))
      (define suffix (substring word i n))
      (when (is-palindrome prefix)
        (define rev-suffix (list->string (reverse (string->list suffix))))
        (when (hash-has-key? word-to-index rev-suffix)
          (define j (hash-ref word-to-index rev-suffix))
          (when (not (= j idx))
            (set! result (cons (list j idx) result)))))
      (when (and (is-palindrome suffix) (not (equal? suffix "")))
        (define rev-prefix (list->string (reverse (string->list prefix))))
        (when (hash-has-key? word-to-index rev-prefix)
          (define j (hash-ref word-to-index rev-prefix))
          (when (not (= j idx))
            (set! result (cons (list idx j) result)))))))
  result)