(define/contract (max-area-rect points)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define point-set (for/set ([p points]) p))
  (define n (length points))
  (define max-area 0)
  (for ([i (in-range n)])
    (for ([j (in-range n)])
      (when (and (< i j)
                 (not (= (first (list-ref points i)) (first (list-ref points j))))
                 (not (= (second (list-ref points i)) (second (list-ref points j)))))
        (define p1 (list-ref points i))
        (define p3 (list-ref points j))
        (define p2 (list (first p3) (second p1)))
        (define p4 (list (first p1) (second p3)))
        (when (and (set-member? point-set p2)
                   (set-member? point-set p4))
          (define area (* (abs (- (first p1) (first p3)))
                          (abs (- (second p1) (second p3)))))
          (when (> area max-area)
            (set! max-area area))))))
  max-area)