(define/contract (unique-middle-mode-subsequences nums)
  (-> (listof exact-integer?) exact-integer?)
  (define n (length nums))
  (define count 0)
  (for ([i (in-range n)])
    (define freq (make-hash))
    (define max-freq 0)
    (define mode-count 0)
    (for ([j (in-range i n)])
      (define num (list-ref nums j))
      (hash-update! freq num add1 0)
      (define current-freq (hash-ref freq num))
      (cond
        [(> current-freq max-freq)
         (set! max-freq current-freq)
         (set! mode-count 1)]
        [(= current-freq max-freq)
         (set! mode-count (add1 mode-count))])
      (when (and (odd? (- j i 1)) (= mode-count 1))
        (set! count (add1 count))))
  count)