(define/contract (smallest-substring s)
  (-> string? string?)
  (let loop ((i 0) (min-len (string-length s)) (result ""))
    (if (>= i (string-length s))
        result
        (let ((j i))
          (while (and (< j (string-length s)) 
                  (char=? (string-ref s i) (string-ref s j)))
            (set! j (add1 j)))
          (let ((current-len (- j i)))
            (if (or (< current-len min-len)
                     (and (= current-len min-len) 
                          (string<? (substring s i j) result)))
                (loop (add1 i) current-len (substring s i j))
                (loop (add1 i) min-len result)))))))