(define/contract (maximum-sum nums)
  (-> (listof exact-integer?) exact-integer?)
  (let ([freq (make-hash)]
        [sums (make-hash)])
    (for ([num nums])
      (hash-update! freq num add1 0))
    (for ([num nums])
    (for ([(num cnt) (in-hash freq)])
      (hash-set! sums num 0))
    (for ([num nums])
      (for ([(k v) (in-hash sums)])
      (hash-update! sums num (lambda (x) (+ x num)) 0))
    (let ([max-sum -inf.0])
      (for ([(num cnt) (in-hash freq)])
        (let ([current-sum (- (hash-ref sums num) num)])
          (when (> current-sum max-sum)
            (set! max-sum current-sum))))
      (if (= max-sum -inf.0) 0 max-sum))))