(define (min-cost houses cost m n target)
  (define dp (make-hash))
  (define (helper pos prev-color groups)
    (if (>= groups target)
        (if (= pos m)
            (if (= groups target) 0 +inf.0)
            (let ((key (list pos prev-color groups)))
              (if (hash-has-key? dp key)
                  (hash-ref dp key)
                  (let ((current-house (list-ref houses pos)))
                    (if (not (zero? current-house))
                        (let ((new-groups (if (= current-house prev-color)
                                              groups
                                              (+ groups 1))))
                          (if (or (zero? prev-color) (= current-house prev-color))
                              (helper (+ pos 1) current-house new-groups)
                              +inf.0))
                        (let ((min-cost +inf.0))
                          (for ([color (in-range 1 (+ n 1))])
                            (let ((new-groups (if (= color prev-color)
                                                 groups
                                                 (+ groups 1))))
                              (when (or (zero? prev-color) (= color prev-color))
                                (set! min-cost (min min-cost
                                                   (+ (list-ref (list-ref cost pos) (- color 1))
                                                      (helper (+ pos 1) color new-groups))))))))
                          min-cost))))))
        +inf.0))
  (let ((result (helper 0 0 0)))
    (if (infinite? result) -1 result)))