(define/contract (max-free-time intervals)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define sorted (sort intervals (λ (a b) (< (car a) (car b)))))
  (define merged (list (car sorted)))
  (for ([interval (cdr sorted)])
    (define last-merged (car merged))
    (if (<= (car interval) (cadr last-merged))
        (set-car! merged (list (car last-merged) (max (cadr last-merged) (cadr interval))))
        (set! merged (cons interval merged))))
  (set! merged (reverse merged))
  (define max-gap 0)
  (for ([i (in-range 1 (length merged))])
    (define gap (- (car (list-ref merged i)) (cadr (list-ref merged (- i 1)))))
    (set! max-gap (max max-gap gap)))
  max-gap)