(define/contract (sum-k-subarrays nums k m)
  (-> (listof exact-integer?) exact-integer? exact-integer? exact-integer?)
  (let* ([n (length nums)]
         [prefix (make-vector (add1 n) 0)])
    (for ([i (in-range n)])
      (vector-set! prefix (add1 i) (+ (vector-ref prefix i) (list-ref nums i)))
    (let ([result 0])
      (for ([i (in-range (- n m) -1 -1)])
        (let ([sum (if (>= i k)
                       (- (vector-ref prefix (+ i m)) (vector-ref prefix i))
                       (vector-ref prefix (+ i m)))])
          (when (>= i k)
            (set! result (+ result sum)))
      result))))