(define/contract (maximum-product nums k)
  (-> (listof exact-integer?) exact-integer? exact-integer?)
  (define n (length nums))
  (define dp (make-hash))
  (hash-set! dp (cons 0 1) 1)
  (for ([num nums])
    (define new-dp (make-hash))
    (for ([(key val) (in-hash dp)])
      (define s (car key))
      (define cnt (cdr key))
      (define new-s (+ s num))
      (define new-cnt (* cnt num))
      (hash-update! new-dp (cons new-s new-cnt) (lambda (v) (+ v val)) 0)
      (hash-update! new-dp key (lambda (v) (+ v val)) 0))
    (set! dp new-dp))
  (define result -1)
  (for ([(key val) (in-hash dp)])
    (define s (car key))
    (define cnt (cdr key))
    (when (and (= s k) (> cnt result))
      (set! result cnt)))
  (if (= result -1) 0 (modulo result (expt 10 9 +7))))