(define/contract (max-envelopes envelopes)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define sorted (sort envelopes (lambda (a b) (or (< (car a) (car b)) (and (= (car a) (car b)) (> (cadr a) (cadr b)))))))
  (define dp (make-vector (length sorted) 1))
  (define len 0)
  (for ([env (in-list sorted)])
    (define h (cadr env))
    (define left 0)
    (define right len)
    (while (< left right)
      (define mid (quotient (+ left right) 2))
      (if (< h (vector-ref dp mid))
          (set! right mid)
          (set! left (+ mid 1)))))
    (when (= left len) (set! len (+ len 1)))
    (vector-set! dp left h))
  len)