(define/contract (min-difference matrix k)
  (-> (listof (listof exact-integer?)) exact-integer? (listof (listof exact-integer?)))
  (define rows (length matrix))
  (define cols (if (null? matrix) 0 (length (car matrix))))
  (define result (make-list (- rows k -1) (make-list (- cols k -1) 0)))
  (for ([i (in-range 0 (- rows k -1))])
    (for ([j (in-range 0 (- cols k -1))])
      (define submatrix
        (for/list ([x (in-range i (+ i k))])
          (for/list ([y (in-range j (+ j k))])
            (list-ref (list-ref matrix x) y))))
      (define flat (apply append submatrix))
      (define sorted (sort flat <))
      (define min-diff
        (for/fold ([min-diff +inf.0])
                  ([a sorted] [b (cdr sorted)])
          (min min-diff (- b a))))
      (list-set! (list-ref result i) j min-diff)))
  result)