(define/contract (can-construct ransom-note magazine)
  (-> string? string? boolean?)
  (let ((note-count (make-hash))
        (mag-count (make-hash)))
    (for ([c (in-string ransom-note)])
      (hash-update! note-count c add1 (lambda () 0)))
    (for ([c (in-string magazine)])
      (hash-update! mag-count c add1 (lambda () 0)))
    (for/and ([(k v) (in-hash note-count)])
      (<= v (hash-ref mag-count k 0)))))