(define (length-longest-path input)
  (define (helper input depth stack max-len)
    (if (string=? input "")
        max-len
        (let* ((newline-pos (string-index-of input #\newline))
               (line (if newline-pos (substring input 0 newline-pos) input))
               (rest (if newline-pos (substring input (add1 newline-pos)) ""))
          (let* ((tab-count (count-tabs line))
            (let loop ((d depth) (s stack))
              (if (>= d tab-count)
                  (let ((current-len (if (null? s) 0 (car s))))
                    (let ((line-len (- (string-length line) tab-count)))
                      (if (string-contains? line ".")
                          (helper rest tab-count (cons (+ current-len line-len) (cdr s)) (max max-len (+ current-len line-len)))
                          (helper rest tab-count (cons (+ current-len line-len 1) (cons (+ current-len line-len 1) (cdr s))) max-len)))
                  (loop (sub1 d) (cdr s))))))))
  (define (count-tabs str)
    (let loop ((i 0) (count 0))
      (if (and (< i (string-length str)) (char=? (string-ref str i) #\tab))
          (loop (add1 i) (add1 count))
          count)))
  (helper input 0 '() 0))