(define/contract (longest-palindrome s)
  (-> string? exact-integer?)
  (let ((freq (make-hash)))
    (for ((c (in-string s)))
      (hash-update! freq c add1 0))
    (let ((len 0)
          (odd-found #f))
      (hash-for-each freq (lambda (k v)
                           (set! len (+ len (quotient v 2) (quotient v 2)))
                           (when (odd? v)
                             (set! odd-found #t))))
      (if odd-found (+ len 1) len))))