(define (min-mutation start end bank)
  (let ((bank-set (list->set bank))
        (queue (mcons (list start 0) '())))
    (if (not (set-member? bank-set end))
        -1
        (let loop ()
          (if (null? (mcar queue))
              -1
              (let* ((current (mcar (mcar queue)))
                    (gene (car current))
                    (steps (cadr current))
                    (queue (mcdr queue)))
                (if (string=? gene end)
                    steps
                    (let ((next-mutations (get-next-mutations gene bank-set)))
                      (for-each (lambda (next)
                                  (set! bank-set (set-remove bank-set next))
                                  (set-add! queue (list next (+ steps 1))))
                                next-mutations)
                      (loop))))))))

(define (get-next-mutations gene bank-set)
  (let ((mutations '())
        (chars '(#\A #\C #\G #\T)))
    (for-each (lambda (i)
                (for-each (lambda (c)
                            (let ((new-gene (string-copy gene)))
                              (string-set! new-gene i c)
                              (if (set-member? bank-set new-gene)
                                  (set! mutations (cons new-gene mutations)))))
                          chars))
              (range (string-length gene)))
    mutations))