(define/contract (circular-array-loop nums)
  (-> (listof exact-integer?) boolean?)
  (define n (length nums))
  (define (next i)
    (modulo (+ i (list-ref nums i)) n))
  (define (same-sign? a b)
    (or (and (positive? a) (positive? b))
        (and (negative? a) (negative? b))))
  (for/or ([i (in-range n)])
    (let loop ([slow i] [fast i])
      (let ([slow-next (next slow)]
            [fast-next (next (next fast))])
        (if (and (same-sign? (list-ref nums slow) (list-ref nums slow-next))
                 (same-sign? (list-ref nums fast) (list-ref nums fast-next))
                 (same-sign? (list-ref nums slow) (list-ref nums fast)))
            (if (= slow fast)
                (not (= slow (next slow)))
                (loop slow-next fast-next))
            #f)))))