(define/contract (island-perimeter grid)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define rows (length grid))
  (define cols (if (null? grid) 0 (length (car grid))))
  (define perimeter 0)

  (for ([i (in-range rows)])
    (for ([j (in-range cols)])
      (when (= (list-ref (list-ref grid i) j) 1)
        (set! perimeter (+ perimeter 4))
        (when (and (> i 0) (= (list-ref (list-ref grid (- i 1)) j) 1))
          (set! perimeter (- perimeter 2)))
        (when (and (> j 0) (= (list-ref (list-ref grid i) (- j 1)) 1))
          (set! perimeter (- perimeter 2))))))
  perimeter)