(define (getMaxRepetitions s1 n1 s2 n2)
  (define len1 (string-length s1))
  (define len2 (string-length s2))
  (define repeat-count 0)
  (define index 0)
  (define memo (make-hash))

  (for ([i (in-range n1)])
    (for ([c (in-string s1)])
      (when (char=? c (string-ref s2 index))
        (set! index (add1 index))
        (when (= index len2)
          (set! repeat-count (add1 repeat-count))
          (set! index 0))))
    (hash-set! memo i (cons repeat-count index))
    (for ([(k v) (in-hash memo)])
      (when (and (not (= k i)) (= (cdr v) index))
        (define prev-repeat (car v))
        (define cycle-len (- i k))
        (define cycle-count (quotient (- n1 (add1 k)) cycle-len))
        (define remaining (remainder (- n1 (add1 k)) cycle-len))
        (set! repeat-count (+ prev-repeat (* cycle-count (- repeat-count prev-repeat))))
        (for ([j (in-range remaining)])
          (for ([c (in-string s1)])
            (when (char=? c (string-ref s2 index))
              (set! index (add1 index))
              (when (= index len2)
                (set! repeat-count (add1 repeat-count))
                (set! index 0)))))
        (set! i n1)
        (break))))
  (quotient repeat-count n2))