(define (find-min-step board hand)
  (let ((freq (make-hash)))
    (for ([c (string->list hand)])
      (hash-update! freq c add1 0))
    (define (dfs b)
      (if (string=? b "")
          0
          (let loop ([i 0] [res +inf.0])
            (if (>= i (string-length b))
                res
                (let ([j i])
                  (while (and (< j (string-length b)) (char=? (string-ref b i) (string-ref b j)))
                    (set! j (+ j 1))
                  (let ([needed (- 3 (- j i))])
                    (if (<= needed 0)
                        (let ([new-b (string-append (substring b 0 i) (substring b j))])
                          (loop 0 (min res (dfs new-b))))
                        (let ([c (string-ref b i)])
                          (if (and (hash-has-key? freq c) (>= (hash-ref freq c) needed))
                              (begin
                                (hash-update! freq c (lambda (v) (- v needed)))
                                (let ([new-b (string-append (substring b 0 i) (substring b j))])
                                  (let ([temp (dfs new-b)])
                                    (hash-update! freq c (lambda (v) (+ v needed)))
                                    (if (not (= temp +inf.0))
                                        (loop j (min res (+ needed temp)))
                                        (loop j res)))))
                              (loop j res))))))))))
    (let ([result (dfs board)])
      (if (= result +inf.0) -1 result))))