(define/contract (find-subsequences nums)
  (-> (listof exact-integer?) (listof (listof exact-integer?)))
  (define result (mutable-set))
  (define (backtrack start path)
    (when (>= (length path) 2)
      (set-add! result (reverse path)))
    (for ([i (in-range start (length nums))])
      (when (or (empty? path) (>= (list-ref nums i) (last path)))
        (backtrack (add1 i) (cons (list-ref nums i) path)))))
  (backtrack 0 '())
  (set->list result))