(define/contract (next-greater-element nums1 nums2)
  (-> (listof exact-integer?) (listof exact-integer?) (listof exact-integer?))
  (define stack '())
  (define hash (make-hash))
  (for ([num (in-list nums2)])
    (while (and (not (null? stack)) (> num (car stack)))
      (hash-set! hash (car stack) num)
      (set! stack (cdr stack)))
    (set! stack (cons num stack)))
  (for/list ([num (in-list nums1)])
    (hash-ref hash num -1)))