(define/contract (find-bottom-left-value root)
  (-> (or/c null? tree-node?) exact-integer?)
  (define q (make-queue))
  (enqueue! q root)
  (define res 0)
  (let loop ()
    (unless (queue-empty? q)
      (define size (queue-length q))
      (for ([i (in-range size)])
        (define node (dequeue! q))
        (when (= i 0) (set! res (tree-node-val node)))
        (when (tree-node-left node) (enqueue! q (tree-node-left node)))
        (when (tree-node-right node) (enqueue! q (tree-node-right node)))))
      (loop)))
  res)