(define (find-rotate-steps ring key)
  (let* ((n (string-length ring))
         (m (string-length key))
         (memo (make-hash))
         (ring-vec (list->vector (string->list ring)))
    (define (dp i j)
      (let ((key (cons i j)))
        (if (hash-has-key? memo key)
            (hash-ref memo key)
            (let ((res (if (= j m)
                          0
                          (let loop ((k 0) (min-steps +inf.0))
                            (if (= k n)
                                min-steps
                                (if (char=? (vector-ref ring-vec k) (string-ref key j))
                                    (let ((steps (min (abs (- k i)) (- n (abs (- k i))))))
                                      (loop (+ k 1) (min min-steps (+ steps 1 (dp k (+ j 1))))))
                                    (loop (+ k 1) min-steps)))))))
              (hash-set! memo key res)
              res))))
    (dp 0 0)))