(define/contract (remove-boxes boxes)
  (-> (listof exact-integer?) exact-integer?)
  (let ([n (length boxes)])
    (let ([dp (make-vector (* n n n) 0)])
      (define (calc-dp i j k)
        (if (> i j) 0
            (let ([idx (+ (* i n n) (* j n) k)])
              (if (> (vector-ref dp idx) 0)
                  (vector-ref dp idx)
                  (let ([max-val (+ (calc-dp (add1 i) j 0) (* (add1 k) (add1 k)))])
                    (for ([m (in-range (add1 i) (add1 j))])
                      (when (equal? (list-ref boxes m) (list-ref boxes i))
                        (set! max-val (max max-val (+ (calc-dp (add1 i) (sub1 m) 0) (calc-dp m j (add1 k)))))))
                    (vector-set! dp idx max-val)
                    max-val)))))
      (calc-dp 0 (sub1 n) 0))))