(define/contract (least-bricks wall)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (let ([edge-count (make-hash)])
    (for ([row wall])
      (let ([sum 0])
        (for ([brick (take row (sub1 (length row)))])
          (set! sum (+ sum brick))
          (hash-update! edge-count sum add1 0))))
    (if (hash-empty? edge-count)
        (length wall)
        (- (length wall) (apply max (hash-values edge-count))))))