(define/contract (check-inclusion s1 s2)
  (-> string? string? boolean?)
  (let* ((len1 (string-length s1))
         (len2 (string-length s2))
         (count1 (make-vector 26 0))
         (count2 (make-vector 26 0)))
    (when (< len2 len1) (return #f))
    (for ([i (in-range len1)])
      (vector-set! count1 (- (char->integer (string-ref s1 i)) 97) 
                   (add1 (vector-ref count1 (- (char->integer (string-ref s1 i)) 97))))
      (vector-set! count2 (- (char->integer (string-ref s2 i)) 97) 
                   (add1 (vector-ref count2 (- (char->integer (string-ref s2 i)) 97)))))
    (define (matches?)
      (for/and ([i (in-range 26)])
        (= (vector-ref count1 i) (vector-ref count2 i))))
    (if (matches?) #t
        (for/fold ([result #f])
                  ([i (in-range len1 len2)] #:break result)
          (vector-set! count2 (- (char->integer (string-ref s2 i)) 97) 
                       (add1 (vector-ref count2 (- (char->integer (string-ref s2 i)) 97))))
          (vector-set! count2 (- (char->integer (string-ref s2 (- i len1))) 97) 
                       (sub1 (vector-ref count2 (- (char->integer (string-ref s2 (- i len1))) 97))))
          (if (matches?) #t #f)))))