(define/contract (valid-square p1 p2 p3 p4)
  (-> (listof integer?) (listof integer?) (listof integer?) (listof integer?) boolean?)
  (define (distance a b)
    (let ((dx (- (car a) (car b)))
          (dy (- (cadr a) (cadr b))))
      (+ (* dx dx) (* dy dy))))
  (let* ((points (list p1 p2 p3 p4))
         (distances (sort (list (distance p1 p2) (distance p1 p3) (distance p1 p4)
                                (distance p2 p3) (distance p2 p4)
                                (distance p3 p4)) <))
    (and (not (equal? p1 p2))
         (not (equal? p1 p3))
         (not (equal? p1 p4))
         (not (equal? p2 p3))
         (not (equal? p2 p4))
         (not (equal? p3 p4))
         (= (car distances) (cadr distances))
         (= (car distances) (caddr distances))
         (= (car distances) (cadddr distances))
         (= (list-ref distances 4) (list-ref distances 5))
         (> (list-ref distances 4) (car distances)))))