(define/contract (find-lhs nums)
  (-> (listof exact-integer?) exact-integer?)
  (let ([freq (make-hash)])
    (for ([num nums])
      (hash-update! freq num add1 0))
    (define max-len 0)
    (for ([(num count) freq])
      (when (hash-has-key? freq (+ num 1))
        (set! max-len (max max-len (+ count (hash-ref freq (+ num 1))))))
    max-len))