(define/contract (schedule-course courses)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define sorted-courses (sort courses (lambda (a b) (< (second a) (second b)))))
  (define max-heap (make-heap (lambda (a b) (> a b))))
  (define total-duration 0)
  (for ([course sorted-courses])
    (define duration (first course))
    (define last-day (second course))
    (if (<= (+ total-duration duration) last-day)
        (begin
          (heap-add! max-heap duration)
          (set! total-duration (+ total-duration duration)))
        (if (and (not (heap-empty? max-heap)) (> duration (heap-max max-heap)))
            (begin
              (set! total-duration (- total-duration (heap-max max-heap)))
              (heap-remove-max! max-heap)
              (heap-add! max-heap duration)
              (set! total-duration (+ total-duration duration)))
            (void))))
  (heap-count max-heap))