(define/contract (smallest-range nums)
  (-> (listof (listof exact-integer?)) (listof exact-integer?))
  (define k (length nums))
  (define pointers (make-vector k 0))
  (define min-range (list -inf.0 +inf.0))
  (define (get-val i) (list-ref (list-ref nums i) (vector-ref pointers i)))
  (let loop ()
    (define current-values (for/list ([i (in-range k)]) (get-val i)))
    (define current-min (apply min current-values))
    (define current-max (apply max current-values))
    (when (< (- current-max current-min) (- (second min-range) (first min-range)))
      (set! min-range (list current-min current-max)))
    (define min-idx (for/fold ([idx 0] [min-val (get-val 0)] #:result idx)
                              ([i (in-range 1 k)])
                      (define val (get-val i))
                      (if (< val min-val) (values i val) (values idx min-val))))
    (vector-set! pointers min-idx (add1 (vector-ref pointers min-idx)))
    (when (< (vector-ref pointers min-idx) (length (list-ref nums min-idx)))
      (loop)))
  min-range)