#lang racket

(define (cherry-pickup grid)
  (let* ([n (vector-length grid)]
         [dp (make-vector (* n n) -1)]
         [dp2 (make-vector (* n n) -1)])
    (vector-set! dp 0 (vector-ref (vector-ref grid 0) 0))
    (for ([step (in-range 1 (- (* 2 n) 1))])
      (for ([i1 (in-range (max 0 (- step (- n 1))) (min n (+ step 1)))])
        (for ([i2 (in-range i1 (min n (+ step 1)))])
          (let ([j1 (- step i1)]
                [j2 (- step i2)])
            (when (and (>= j1 0) (< j1 n) (>= j2 0) (< j2 n)
                      (not (= (vector-ref (vector-ref grid i1) j1) -1))
                      (not (= (vector-ref (vector-ref grid i2) j2) -1)))
              (let ([best -1])
                (when (>= (- i1 1) 0)
                  (when (>= (- i2 1) 0)
                    (set! best (max best (vector-ref dp (+ (* (- i1 1) n) (- i2 1))))))
                (when (>= (- i1 1) 0)
                  (set! best (max best (vector-ref dp (+ (* (- i1 1) n) i2)))))
                (when (>= (- i2 1) 0)
                  (set! best (max best (vector-ref dp (+ (* i1 n) (- i2 1)))))
                (set! best (max best (vector-ref dp (+ (* i1 n) i2))))
                (when (>= best 0)
                  (if (= i1 i2)
                      (vector-set! dp2 (+ (* i1 n) i2) (+ best (vector-ref (vector-ref grid i1) j1)))
                      (vector-set! dp2 (+ (* i1 n) i2) (+ best (vector-ref (vector-ref grid i1) j1) (vector-ref (vector-ref grid i2) j2)))))))))))
      (let ([temp dp])
        (set! dp dp2)
        (set! dp2 temp))
      (for ([i (in-range (* n n))])
        (vector-set! dp2 i -1)))
    (max 0 (vector-ref dp (- (* n n) 1)))))