#lang racket

(define (contain-virus isInfected)
  (define rows (length isInfected))
  (define cols (if (null? isInfected) 0 (length (car isInfected))))
  (define (get-regions)
    (define visited (make-hash))
    (define regions '())
    (define walls 0)
    (define (dfs i j region infected-neighbors)
      (hash-set! visited (cons i j) #t)
      (set! region (cons (cons i j) region))
      (for ([dir '((0 . 1) (1 . 0) (0 . -1) (-1 . 0))])
        (define ni (+ i (car dir)))
        (define nj (+ j (cdr dir)))
        (cond
          [(or (< ni 0) (>= ni rows) (< nj 0) (>= nj cols))
           (void)]
          [(= (list-ref (list-ref isInfected ni) nj) 0)
           (set! infected-neighbors (cons (cons ni nj) infected-neighbors))
           (set! walls (add1 walls))]
          [(and (= (list-ref (list-ref isInfected ni) nj) 1)
                (not (hash-ref visited (cons ni nj) #f)))
           (dfs ni nj region infected-neighbors)])))
    (for ([i (in-range rows)])
      (for ([j (in-range cols)])
        (when (and (= (list-ref (list-ref isInfected i) j) 1)
                   (not (hash-ref visited (cons i j) #f)))
          (define region '())
          (define infected-neighbors '())
          (dfs i j region infected-neighbors)
          (set! regions (cons (list region walls (remove-duplicates infected-neighbors)) regions))
          (set! walls 0)))
    (sort regions (lambda (a b) (> (length (third a)) (length (third b))))))
  (define result 0)
  (let loop ()
    (define regions (get-regions))
    (when (null? regions) (void))
      (define to-build (first regions))
      (set! result (+ result (second to-build)))
      (for ([cell (first to-build)])
        (define i (car cell))
        (define j (cdr cell))
        (list-set! (list-ref isInfected i) j -1))
      (for ([region (cdr regions)])
        (for ([cell (third region)])
          (define i (car cell))
          (define j (cdr cell))
          (list-set! (list-ref isInfected i) j 1))
      (loop))
  result)