(define/contract (order-of-largest-plus-sign n mines)
  (-> exact-integer? (listof (listof exact-integer?)) exact-integer?)
  (let* ([grid (make-vector (* n n) 1)]
         [left (make-vector (* n n) 0)]
         [right (make-vector (* n n) 0)]
         [up (make-vector (* n n) 0)]
         [down (make-vector (* n n) 0)]
         [result 0])
    (for ([mine mines])
      (let ([x (first mine)]
            [y (second mine)])
      (vector-set! grid (+ (* x n) y) 0))
    (for ([i (in-range n)])
      (let ([count 0])
        (for ([j (in-range n)])
          (if (> (vector-ref grid (+ (* i n) j)) 0)
              (set! count (+ count 1))
              (set! count 0))
          (vector-set! left (+ (* i n) j) count)))
      (let ([count 0])
        (for ([j (in-range (- n 1) -1 -1)])
          (if (> (vector-ref grid (+ (* i n) j)) 0)
              (set! count (+ count 1))
              (set! count 0))
          (vector-set! right (+ (* i n) j) count))))
    (for ([j (in-range n)])
      (let ([count 0])
        (for ([i (in-range n)])
          (if (> (vector-ref grid (+ (* i n) j)) 0)
              (set! count (+ count 1))
              (set! count 0))
          (vector-set! up (+ (* i n) j) count)))
      (let ([count 0])
        (for ([i (in-range (- n 1) -1 -1)])
          (if (> (vector-ref grid (+ (* i n) j)) 0)
              (set! count (+ count 1))
              (set! count 0))
          (vector-set! down (+ (* i n) j) count))))
    (for ([i (in-range n)])
      (for ([j (in-range n)])
        (let ([current (min (vector-ref left (+ (* i n) j))
                            (vector-ref right (+ (* i n) j))
                            (vector-ref up (+ (* i n) j))
                            (vector-ref down (+ (* i n) j)))])
          (when (> current result)
            (set! result current))))
    result))