(define/contract (swim-in-water grid)
  (-> (listof (listof exact-integer?)) exact-integer?)
  (define n (length grid))
  (define directions '((0 1) (1 0) (0 -1) (-1 0)))
  (define min-heap (make-heap (lambda (a b) (< (car a) (car b)))))
  (heap-add! min-heap (cons (list-ref (list-ref grid 0) 0) (cons 0 0)))
  (define visited (make-hash))
  (hash-set! visited (cons 0 0) #t)
  (define result 0)
  (let loop ()
    (define current (heap-min min-heap))
    (heap-remove! min-heap)
    (define t (car current))
    (define i (car (cdr current)))
    (define j (cdr (cdr current)))
    (set! result (max result t))
    (when (and (= i (- n 1)) (= j (- n 1)))
      result)
    (for ([dir directions])
      (define ni (+ i (car dir)))
      (define nj (+ j (cadr dir)))
      (when (and (>= ni 0) (< ni n) (>= nj 0) (< nj n) (not (hash-has-key? visited (cons ni nj))))
        (hash-set! visited (cons ni nj) #t)
        (heap-add! min-heap (cons (list-ref (list-ref grid ni) nj) (cons ni nj)))))
    (loop)))