(define/contract (letter-case-permutation s)
  (-> string? (listof string?))
  (define (permute str idx)
    (if (= idx (string-length str))
        (list str)
        (let* ([c (string-ref str idx)]
               [rest (permute str (add1 idx))])
          (if (char-alphabetic? c)
              (append
               (map (lambda (s) (string-append (substring str 0 idx)
                                              (string (char-downcase c))
                                              (substring s (add1 idx))))
                    rest)
               (map (lambda (s) (string-append (substring str 0 idx)
                                              (string (char-upcase c))
                                              (substring s (add1 idx))))
                    rest))
              rest))))
  (permute s 0))