(define (champagne-tower poured query_row query_glass)
  (define tower (make-vector (add1 query_row) (make-vector (add1 query_row) 0.0)))
  (vector-set! (vector-ref tower 0) 0 (exact->inexact poured))
  (for ([row (in-range 0 query_row)])
    (for ([glass (in-range 0 (add1 row))])
      (define excess (- (vector-ref (vector-ref tower row) glass) 1.0))
      (when (> excess 0.0)
        (vector-set! (vector-ref tower (add1 row)) glass (+ (vector-ref (vector-ref tower (add1 row)) glass) (/ excess 2.0)))
        (vector-set! (vector-ref tower (add1 row)) (add1 glass) (+ (vector-ref (vector-ref tower (add1 row)) (add1 glass)) (/ excess 2.0))))))
  (min 1.0 (vector-ref (vector-ref tower query_row) query_glass)))